
/*************************************************************/
/* PROJECT NAME: UART	                                    */
/* Project:      LPC2100 Training course                    */
/* Engineer:     T Martin      tmartin@hitex.co.uk          */
/* Filename:     main.c                                     */
/* Language:     C                      	                */
/* Compiler:     Keil ARM	V2.00b		                    */
/* Assembler:    				                            */
/*                                                          */
/************************************************************/
/* COPYRIGHT: Hitex UK Ltd 		2005						*/
/* LICENSE:   THIS VERSION CREATED FOR FREE DISTRIBUTION	*/
/************************************************************/
/* Function:                                                */
/*                                                          */
/* Example           							  			*/
/*															*/
/* 			Demonstrates RS232 Comms						*/
/*															*/	
/* Oscillator frequency 12.000 Mhz							*/
/* Target board Keil MCB2100								*/
/************************************************************/


#define CR     0x0D
#include <LPC21xx.H>
 
void init_serial (void);
int putchar (int ch);
int getchar (void);


unsigned char test;

int main(void)
{
VPBDIV = 0x02;						//Divide Pclk by two
init_serial();

while(1)
{

putchar(getchar());					//Echo terminal
}
}

void init_serial (void)			  	/* Initialize Serial Interface       */
{               	   
  PINSEL0 	= 0x00050000;         	/* Enable RxD1 and TxD1              */ 
  U1LCR 	= ;         			/* 8 bits, no Parity, 1 Stop bit     */
  U1DLL 	= ;         			/* 9600 Baud Rate @ 30MHz VPB Clock  */
  U1LCR 	= ;			        	/* DLAB = 0                          */
}


int putchar (int ch) 			  /* Write character to Serial Port    */
{                  		

  if (ch == '\n')  {
    while (!(U1LSR & 0x20));
    U1THR = CR;              	   /* output CR */
  }
  while (!(U1LSR & 0x20));
  return (U1THR = ch);
}


int getchar (void) 				/* Read character from Serial Port   */
{                    

  while (!(U1LSR & 0x01));

  return (U1RBR);
}
